﻿using Helper;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Net;
using System.Runtime.InteropServices;
using System.Text;

namespace Win32Helper
{
    public class ImageHelper
    {
        /// <summary>
        /// 加载图片
        /// </summary>
        [ComVisible(true)]
        public static Image GetImage(string url)
        {
            try
            {
                if (StringEx.IsBase64String(url))
                {
                    return ConvertEx.Base64ToObject(url) as Image;
                }
                if (url.Contains("http"))
                {
                    HttpHelper.SetSSL();
                    HttpWebRequest req = (HttpWebRequest)WebRequest.Create(url);
                    req.Accept = "text/html, application/xhtml+xml, */*";
                    req.UserAgent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)";
                    req.ProtocolVersion = HttpVersion.Version11;
                    ServicePointManager.Expect100Continue = false;
                    req.Timeout = HttpHelper.TimeOut == 0 ? 5000 : HttpHelper.TimeOut;
                    HttpWebResponse myHttpWebResponse = (HttpWebResponse)req.GetResponse();
                    return Image.FromStream(myHttpWebResponse.GetResponseStream());
                }
                else { return Image.FromFile(url); }
            }
            catch (Exception)
            {
                return null;
            }
        }
    }
}
